DROP VIEW public.v_orcamento_pbm;
DROP VIEW public.v_orcamento;
DROP VIEW public.v_est_orc;



create or replace function addcolumn() 
returns void as 
$body$ 
begin 
    
    if  not exists (select 1 
					  from information_schema.columns 
                     where table_name= 'est_orc' 
                       and column_name='tipo_pbm') then 
		   
		alter table est_orc alter column tipo_pbm type integer;
        
		raise notice 'operacao realizada com sucesso.';
    else 
		raise notice 'coluna existe.'; 
    end if; 
      
end; 
-- fim bloco principal 
$body$ 
language plpgsql volatile 
  cost 100; 
alter function addcolumn() owner to postgres; 
select addcolumn(); 
drop function addcolumn();




CREATE OR REPLACE VIEW public.v_orcamento_pbm AS
 SELECT orc.cd_emp,
    orc.cd_filial,
    orc.cd_orc,
    orc.dt_emi,
    orc.hr_emi,
    orc.nr_ped_televd AS nr_pedido,
    conv.cd_conv,
    conv.ds_conv AS nm_conv,
    conv.cd_cli AS cd_cli_conv,
    cli.rz_cli AS nm_cli_conv,
    orc.tipo_pbm,
    orc.modalidade_pbm,
    orc.cd_projeto_pbm,
    orc.dt_receita_pbm,
    orc.cpf_cli_pbm,
    orc.nr_cartao_pbm,
    orc.cd_dependente_pbm,
    orc.nr_rg_dependente_pbm,
    orc.usu_nm_farm_popular AS farm_popular_usu,
    orc.usu_sh_farm_popular AS farm_popular_senha,
    COALESCE(NULLIF(cpl.nr_autr_pbm_item::text, '0'::text), orc.nr_autr_pbm::text) AS nr_autr_pbm,
    cpl.cd_prod,
    prod.ds_prod,
    cpl.vlr_pbm AS vlr_prod_reembolso,
    cpl.qt_aut_pbm,
    cpl.vlr_it_autr_pbm,
    cpl.vlr_desc_autr_pbm,
    cpl.vlr_cliente AS vlr_prod_cli
   FROM est_orc orc
     JOIN rc_cli cli ON orc.cd_emp = cli.cd_emp AND orc.tipo_pbm = cli.rot_conv_ext::numeric
     JOIN rc_cli_conv conv ON cli.cd_emp = conv.cd_emp AND cli.cd_cli = conv.cd_cli AND conv.tp_conv = 2::numeric
     JOIN est_orc_cpl cpl ON orc.cd_emp = cpl.cd_emp AND orc.cd_filial = cpl.cd_filial AND orc.cd_orc = cpl.cd_orc
     LEFT JOIN est_prod prod ON cpl.cd_emp = prod.cd_emp AND cpl.cd_prod = prod.cd_prod
  WHERE orc.tipo_pbm > 0::numeric;

ALTER TABLE public.v_orcamento_pbm
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_orcamento AS
 SELECT orc.cd_emp,
    orc.cd_filial,
    orc.cd_orc,
    orc.dt_emi,
    orc.hr_emi,
    orc.nr_ped_televd AS nr_pedido,
    orc.vlr_tot,
        CASE
            WHEN COALESCE(orc.cd_conv, 0::numeric) <> 0::numeric THEN 1
            ELSE NULL::integer
        END AS contem_convenio,
    COALESCE(cli_conv.ds_conv, ''::character varying) AS ds_conv,
        CASE
            WHEN COALESCE(orc.tipo_pbm, '-1'::integer::numeric) <> '-1'::integer::numeric THEN 1
            ELSE NULL::integer
        END AS contem_pbm,
        CASE
            WHEN orc.tp_orc_entg = 1::numeric THEN 1
            ELSE NULL::integer
        END AS contem_entrega,
        CASE
            WHEN receita.nr_orc IS NOT NULL THEN 1
            ELSE NULL::integer
        END AS contem_receita,
    COALESCE(receita.cd_medico_rec, 0) AS medico_id,
    medico.nm_medico AS medico_nm,
    medico.cd_tp_doc AS medico_tp_doc,
    medico.nr_doc AS medico_nr_doc,
    medico.uf_doc AS medico_uf_doc,
    COALESCE(receita.nr_receita::numeric, 0::bigint::numeric) AS numero_receita,
    COALESCE(receita.cd_receita, 0) AS codigo_receita,
    receita.dt_receita,
    receita.tp_capt_receita AS tipo_captacao_receita,
    orc.cd_cli,
    orc.nm_cli,
    COALESCE(orc.cgc_cpf, cli.cgc_cpf) AS cli_cgccpf,
    orc.nr_cartao_fidelidade AS nr_cartao_cli,
    orc.fone_cli,
    orc.nm_comprador,
    orc.tp_orc,
    orc.tipo_prazo_pgto AS tp_prazo_pgto,
    orc.cd_frm_pgto AS cd_forma_pgto,
    orc.orig_orc AS origem_orc,
    orc.vd_troca_fidel,
    orc.sts_orc,
    orc.obs,
    orc.dados_adicionais,
    orc.offline,
    COALESCE(orc.flag_consolidado, 0) AS flag_consolidado,
    cpl.cd_prod,
    NULL::character varying AS ds_prod,
    cpl.qt AS qt_it,
    cpl.vlr_it,
    cpl.vlr_tot_it,
    cpl.vlr_desc,
    COALESCE(cpl.perc_desc, 0::numeric) AS "coalesce",
    cpl.cd_vend,
    NULL::character varying AS nm_vend,
    orc.cd_vend_lib AS vend_lib,
    NULL::character varying AS vend_lib_nm,
    cpl.pr_tab AS vlr_it_tab,
    cpl.oferta AS is_oferta_it,
    cpl.perc_desc_cad,
    cpl.perc_desc_fix,
    cpl.vlr_desc_fix,
    cpl.tipo_desconto AS tp_desc,
    cpl.qtde_ponto_fidel AS qt_pontos_fidel,
    cpl.vlr_economia,
    cpl.vlr_desc_verba,
    cpl.perc_desc_verba,
    cpl.cd_vend_verba,
    NULL::character varying AS nm_vend_verba,
    cpl.libera_vd_conv,
    cpl.vlr_custo_semaforo,
    cpl.qt_est,
    cpl.cd_grp AS cd_grupo_comissao,
    cpl.nr_protocolo_manipulado,
    cpl.perc_desconto_pos_pbm,
    desconto_concorrente.cd_concor AS cd_concorrente,
    desconto_concorrente.vlr_concor AS vlr_concorrente,
        CASE
            WHEN COALESCE(est_cancel.cd_mt_cancel_orc, 0) > 0 THEN true
            ELSE false
        END AS orcamento_cancel,
    COALESCE(est_cancel.cd_mt_cancel_orc, 0) AS codigomotivocancel,
    est_cancel.desc_mt_cancel AS descricaomotivocancel,
    lote.cd_lote,
    lote.qtde_lote,
    receita.nm_comprador AS nm_comprador_rec,
    receita.idade AS idade_rec,
    receita.nm_paciente AS nm_paciente_rec,
    receita.receita_tipo AS receita_tipo_rec,
    COALESCE(receita.cid, 0) AS cid_rec,
    receita.uf AS uf_rec,
    receita.nr_doc_cli AS nr_doc_cli_rec,
    receita.tipo_documento AS tipo_documento_rec,
    cpl.venda_dependente,
    cpl.cd_it,
    cpl.perc_desc_min,
    cpl.perc_desc_max,
    cpl.cd_tbl_desc,
    COALESCE(cpl.perc_desc_diff, 0::numeric) AS perc_desc_diff
   FROM est_orc orc
     JOIN est_orc_cpl cpl ON orc.cd_emp = cpl.cd_emp AND orc.cd_filial = cpl.cd_filial AND orc.cd_orc = cpl.cd_orc
     LEFT JOIN rc_cli cli ON orc.cd_emp = cli.cd_emp AND orc.cd_cli = cli.cd_cli
     LEFT JOIN rc_cli_conv cli_conv ON orc.cd_conv = cli_conv.cd_conv AND orc.cd_emp = cli_conv.cd_emp
     LEFT JOIN est_orc_glb_medico receita ON cpl.cd_emp = receita.cd_emp::numeric AND cpl.cd_filial = receita.cd_filial::numeric AND cpl.cd_orc = receita.nr_orc::numeric AND cpl.cd_prod = receita.cd_prod::numeric
     LEFT JOIN glb_medicos medico ON cpl.cd_emp = medico.cd_emp::numeric AND receita.cd_medico_rec = medico.cd_ctr
     LEFT JOIN est_orc_cpl_concor desconto_concorrente ON cpl.cd_emp = desconto_concorrente.cd_emp::numeric AND cpl.cd_filial = desconto_concorrente.cd_filial::numeric AND cpl.cd_orc = desconto_concorrente.nr_orc::numeric
     LEFT JOIN est_orc_mt_cancel est_cancel ON est_cancel.cd_emp::numeric = orc.cd_emp AND est_cancel.cd_filial::numeric = orc.cd_filial AND est_cancel.cd_orc::numeric = orc.cd_orc
     LEFT JOIN est_orc_cpl_lote lote ON cpl.cd_emp = lote.cd_emp AND cpl.cd_filial = lote.cd_filial AND cpl.cd_orc = lote.cd_orc AND cpl.cd_prod = lote.cd_prod;

ALTER TABLE public.v_orcamento
    OWNER TO postgres;



CREATE OR REPLACE VIEW public.v_est_orc AS
 SELECT est_orc.cd_emp,
    est_orc.cd_filial,
    est_orc.cd_orc,
    est_orc.vd_troca_fidel,
    est_orc.cd_cli,
    est_orc.cd_conv,
    est_orc.qt_parc_conv,
    est_orc.nr_ped_televd,
    est_orc.tipo_prazo_pgto,
    est_orc.nr_cartao_pbm,
    est_orc.cd_projeto_pbm,
    est_orc.tp_perc_rec_conv,
    est_orc.perc_rec_conv,
    est_orc.dados_adicionais,
    est_orc.nm_comprador,
    est_orc.qtd_dias_prorrog,
    est_orc.tipo_pbm,
    est_orc.cd_cli_dep,
    est_orc.vlr_prod,
    est_orc.tp_orc_entg,
    est_orc.sts_orc,
    est_orc_cpl.cd_prod,
    est_orc_cpl.cd_barra,
    est_orc_cpl.qt,
    est_orc_cpl.vlr_it,
    est_orc_cpl.perc_desc,
    est_orc_cpl.cd_medico_rec,
    est_orc_cpl.cd_vend,
    est_orc_cpl.nr_autr_pbm_item,
    est_orc_cpl.cd_vend_verba,
    est_orc_cpl.libera_vd_conv,
        CASE
            WHEN est_prod.ds_usual IS NULL THEN ''::character varying
            ELSE est_prod.ds_usual
        END AS ds_usual,
    est_orc_cpl.cd_it,
    est_orc_cpl.perc_desc_min,
    est_orc_cpl.perc_desc_max,
    est_orc_cpl.cd_tbl_desc
   FROM est_orc
     JOIN est_orc_cpl ON est_orc_cpl.cd_emp = est_orc.cd_emp AND est_orc_cpl.cd_filial = est_orc.cd_filial AND est_orc_cpl.cd_orc = est_orc.cd_orc
     LEFT JOIN est_prod ON est_orc_cpl.cd_emp = est_prod.cd_emp AND est_orc_cpl.cd_prod = est_prod.cd_prod;

ALTER TABLE public.v_est_orc
    OWNER TO postgres;

